import { ComponentClassName } from "@/types/utility";
import { MainNavigation } from "./main-navigation";
import { MobileNavigation } from "./mobile-navigation";

export function SiteHeader({ children }: ComponentClassName) {
  return (
    <header className="supports-[backdrop-filter]:bg-background/60 sticky top-0 z-50 flex justify-center border-b border-border/40 backdrop-blur">
      <div className="container flex items-center h-14 px-4">
        <MainNavigation />
        <MobileNavigation />

        <div className="hidden flex-1 items-center justify-end space-x-2 sm:flex">
          <div className="flex items-center gap-4">
            {children}
          </div>
        </div>
      </div>
    </header>
  );
}
